*---------------------------------------------------------------*
*	Assember options					*
*---------------------------------------------------------------*

	OPT		W-
	COMMENT		HEAD=1

*---------------------------------------------------------------*
*	Equates							*
*---------------------------------------------------------------*

dc4			=	$80000000
ic4			=	$00008000

cookie_jar		=	$5a0

magic_frb_start		=	8192*2

*---------------------------------------------------------------*

			rsreset
pmmu_start		rs.l	1
pmmu_end		rs.l	1
pmmu_read		rs.l	1
pmmu_write		rs.l	1
pmmu_cmw		rs.l	1
pmmu_cmc		rs.l	1
pmmu_cms		rs.l	1
pmmu_cmn		rs.l	1

*---------------------------------------------------------------*

push	macro
	move.\0		\1,-(sp)
	endm
	
pop	macro
	move.\0		(sp)+,\1
	endm

pushall	macro
	movem.l		d0-d7/a0-a6,-(sp)
	endm
	
popall	macro
	movem.l		(sp)+,d0-d7/a0-a6
	endm

fcache	macro		* flush cache(s) [type]
	nop
	cpusha		\1
	nop
	endm

icache	macro		* invalidate cache(s) [type]
	nop
	cinva		\1
	nop
	endm

ecache	macro		* flush & edit cache(s) [type], [reg]
	fcache		\1
	movec		\2,cacr
	endm

*---------------------------------------------------------------*
*	Program start						*
*---------------------------------------------------------------*
start:	bra.l		realstart
*---------------------------------------------------------------*
	ds.b		8192
*---------------------------------------------------------------*
realstart:
*---------------------------------------------------------------*
	lea		usp_stack,sp
*---------------------------------------------------------------*
*	Enter supervisor mode					*
*---------------------------------------------------------------*
	move.l		sp,os_usp_stack
	pea		ssp_stack
	push.w		#32
	trap		#1
	move.l		d0,os_ssp_stack
*---------------------------------------------------------------*
	sf		stay_resident
*---------------------------------------------------------------*
*	Ensure it runs in ST-RAM				*
*---------------------------------------------------------------*
	lea		start,a0
	cmp.l		#$00E00000,a0
	bmi.s		.cont
	lea		msg_stram,a0
	bsr		cconws
	bra.s		general_error
*---------------------------------------------------------------*
*	Check driver status					*
*---------------------------------------------------------------*
.cont:	clr.l		exit_code
	bsr		check_driver
	tst.l		exit_code
	beq.s		switch_caches
*---------------------------------------------------------------*
driver_missing:
*---------------------------------------------------------------*
	lea		missing,a0
	bsr		cconws
*---------------------------------------------------------------*
general_error:
*---------------------------------------------------------------*
	moveq		#4,d0
	bsr		delay
	bra		exit_program
*---------------------------------------------------------------*
switch_caches:
*---------------------------------------------------------------*
*	Sign-on message						*
*---------------------------------------------------------------*
	lea		sign_on,a0
	bsr		cconws
*---------------------------------------------------------------*
*	Install driver						*
*---------------------------------------------------------------*
	bsr		install
*---------------------------------------------------------------*
exit_program:
*---------------------------------------------------------------*
*	User mode						*
*---------------------------------------------------------------*
	push.l		os_ssp_stack
	push.w		#32
	trap		#1
	move.l		os_usp_stack,sp
*---------------------------------------------------------------*
*	Terminate						*
*---------------------------------------------------------------*
	push.w		#0
	tst.b		stay_resident
	beq.s		.pterm
	move.l		#start,d0
	add.l		#8192-1,d0
	and.l		#-8192,d0
	sub.l		#start,d0
	add.l		#256,d0
	push.l		d0
	push.w		#49
.pterm:	trap		#1

*---------------------------------------------------------------*
*	Check for previous 68040 driver installation		*
*---------------------------------------------------------------*
check_driver:
*---------------------------------------------------------------*
	move.l		#'XMMU',d0
	bsr		cookie_search
	move.l		d0,exit_code
*---------------------------------------------------------------*
*	Detect Magic's presence					*
*---------------------------------------------------------------*
	move.l		#'MagX',d0
	bsr		cookie_search
	tst.l		d0
	seq		magic_resident
	rts

*---------------------------------------------------------------*
install:
*---------------------------------------------------------------*
	move.l		#'AB40',d0
	bsr		cookie_search
	move.l		4(a0),a1
	move.l		a1,softcacr_ptr	
*---------------------------------------------------------------*
*	Find XMMU table						*
*---------------------------------------------------------------*
	move.l		#'XMMU',d0
	bsr		cookie_search
	move.l		4(a0),pmmu_ptr
*---------------------------------------------------------------*
*	Disable caches						*
*---------------------------------------------------------------*
	move.l		softcacr_ptr,a1
	moveq		#0,d0
	push.l		(a1)
	move.l		d0,(a1)
	ecache		bc,d0
*---------------------------------------------------------------*
*	Find XMMU noncacheable routine				*
*---------------------------------------------------------------*
	move.l		pmmu_ptr,a0
	move.l		pmmu_cmn(a0),a2
*---------------------------------------------------------------*
*	Find physical RAMBOT					*
*---------------------------------------------------------------*
	lea		magic_frb_start,a0
	tst.b		magic_resident
	bne.s		.gots
	move.l		#start+(8192-1),d0
	and.l		#-8192,d0
	move.l		d0,a0
*---------------------------------------------------------------*
*	Find physical RAMTOP (4MB or 14MB)			*
*---------------------------------------------------------------*
.gots:	move.l		$42e.w,d1
	add.l		#$00400000-1,d1
	add.l		#-$00400000,d1
	cmp.l		#$00E00000,d1
	blo.s		.skip
	move.l		#$00E00000,d1
.skip:	move.l		d1,a1
*---------------------------------------------------------------*
*	Mark ST-RAM noncacheable				*
*---------------------------------------------------------------*
	jsr		(a2)	
*---------------------------------------------------------------*
*	Restore caches						*
*---------------------------------------------------------------*
.err:	pop.l		d0
	move.l		softcacr_ptr,a1
	move.l		d0,(a1)
	ecache		bc,d0
*---------------------------------------------------------------*
	st		stay_resident
*---------------------------------------------------------------*
	rts

*---------------------------------------------------------------*
cookie_search:
*---------------------------------------------------------------*
	move.l		cookie_jar.w,a0
.loop:	cmp.l		(a0),d0
	beq.s		.find
	tst.l		(a0)
	beq.s		.fail
	addq.l		#8,a0
	bra.s		.loop
.find:	moveq		#0,d0
	bra.s		.end
.fail:	moveq		#-1,d0
.end:	rts

*---------------------------------------------------------------*
delay:
*---------------------------------------------------------------*
	mulu.w		#50,d0
.wt:	push.w		d0
	push.w		#37
	trap		#14
	addq.l		#2,sp
	pop.w		d0
	dbra		d0,.wt
	rts

*---------------------------------------------------------------*
cconws:
*---------------------------------------------------------------*
	pea		(a0)
	push.w		#9
	trap		#1		; cconws
	addq.l		#6,sp
	rts

*---------------------------------------------------------------*
			data
*---------------------------------------------------------------*

sign_on:		dc.b	13,10
			dc.b	27,'p'
			dc.b	' Remaining ST-RAM is now 68040/DMA friendly! ',13,10
			dc.b	27,'q'
			dc.b	0

missing:		dc.b	27,'E'
			dc.b	'MC68040 ToolKit driver is not installed!',13,10
			dc.b	0

msg_stram:		dc.b	27,'E'
			dc.b	'This program can only run in ST-RAM! Change the flags!',13,10
			dc.b	0
		
*---------------------------------------------------------------*
			bss
*---------------------------------------------------------------*

softcacr_ptr:		ds.l	1
pmmu_ptr:		ds.l	1
exit_code:		ds.l	1
magic_resident:		ds.l	1
stay_resident:		ds.l	1

*---------------------------------------------------------------*

os_ssp_stack:		ds.l	1
os_usp_stack:		ds.l	1

			ds.b	2048
ssp_stack:		ds.l	1
			ds.b	2048
usp_stack:		ds.l	1

*---------------------------------------------------------------*
